using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class WKF_CASE_ACTIVITYDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public WKF_CASE_ACTIVITYDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public WKF_CASE_ACTIVITY GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            WKF_CASE_ACTIVITY objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            Int32? objReturn = objSave.WKF_CASE_ACTIVITY_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, objSave.ADDRESS_LINE3, objSave.BEST_CALL_BACK_TIME, objSave.CITY, objSave.CONTACT_EMAIL, objSave.CONTACT_NAME, objSave.CONTACT_PHONE, objSave.COUNTRY, DateTime.Now, objSave.CREATEDBY, objSave.INFO_CONVEYED_TEXT, objSave.INFO_RECEIVED_TEXT, objSave.POSTAL_CODE, objSave.STATE, objSave.STD_WKFACTIVITYTYPE_ID, DateTime.Now, objSave.UPDATEDBY, ref objReturn, objSave.WKF_CASE_ID, objSave.STD_WKFACTIVITYSTS_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_delete(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            List<STD_WKFACTIVITYTYPE> objTemp = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = dbContext.usp_STD_WKFACTIVITYTYPE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = objTemp.Where(r => r.STD_REGISTRY_ID == CURRENT_REGISTRY_ID).ToList();
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objReturn != null && objTemp != null)
                        objReturn = (from s in objReturn where (from t in objTemp select t.ID).Contains(s.STD_WKFACTIVITYTYPE_ID) select s).ToList();

                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (WKF_CASE_ACTIVITY act in objReturn)
                        {
                            if (act.WKF_CASE_ID > 0)
                            {
                                act.WKF_CASE = dbContext.usp_WKF_CASE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE_ID).FirstOrDefault();
                                if (act.WKF_CASE != null)
                                {
                                    if (act.WKF_CASE.STD_WKFCASETYPE_ID > 0)
                                        act.WKF_CASE.STD_WKFCASETYPE = dbContext.usp_STD_WKFCASETYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.STD_WKFCASETYPE_ID).FirstOrDefault();

                                    if (act.WKF_CASE.STD_WKFCASESTS_ID > 0)
                                        act.WKF_CASE.STD_WKFCASESTS = dbContext.usp_STD_WKFCASESTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.STD_WKFCASESTS_ID).FirstOrDefault();

                                    if (act.WKF_CASE.PATIENT_ID > 0)
                                        act.WKF_CASE.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.PATIENT_ID).FirstOrDefault();

                                    if (act.WKF_CASE.REFERRAL_ID != null && act.WKF_CASE.REFERRAL_ID > 0)
                                        act.WKF_CASE.REFERRAL = dbContext.usp_REFERRAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.REFERRAL_ID.Value).FirstOrDefault();
                                }
                            }

                            if (act.STD_WKFACTIVITYTYPE_ID > 0)
                            {
                                act.STD_WKFACTIVITYTYPE = dbContext.usp_STD_WKFACTIVITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYTYPE_ID).FirstOrDefault();
                            }

                            if (act.STD_WKFACTIVITYSTS_ID > 0)
                            {
                                act.STD_WKFACTIVITYSTS = dbContext.usp_STD_WKFACTIVITYSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYSTS_ID).FirstOrDefault();
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetItemsByWorkstream(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitemsByWorkstream(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID).ToList();
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objReturn = objReturn.Where(r => r.WKF_CASE_ID == WKF_CASE_ID).ToList();

                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (WKF_CASE_ACTIVITY act in objReturn)
                        {
                            if (act.WKF_CASE_ID > 0)
                            {
                                act.WKF_CASE = dbContext.usp_WKF_CASE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE_ID).FirstOrDefault();
                            }

                            if (act.STD_WKFACTIVITYTYPE_ID > 0)
                            {
                                act.STD_WKFACTIVITYTYPE = dbContext.usp_STD_WKFACTIVITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYTYPE_ID).FirstOrDefault();
                            }

                            if (act.STD_WKFACTIVITYSTS_ID > 0)
                            {
                                act.STD_WKFACTIVITYSTS = dbContext.usp_STD_WKFACTIVITYSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYSTS_ID).FirstOrDefault();
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID, Int32 STD_WKFACTIVITYSTS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_updateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID, STD_WKFACTIVITYSTS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
